/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.util.JsonHelper;

public record BlockPropertiesPredicate(class_2248 block, List<Matcher> properties) implements BlockPredicate
{
    private static final Function<String, RuntimeException> JSON_EXCEPTION = JsonSyntaxException::new;
    private static final Function<String, RuntimeException> DECODER_EXCEPTION = DecoderException::new;
    public static final GenericLoaderRegistry.IGenericLoader<BlockPropertiesPredicate> LOADER = new GenericLoaderRegistry.IGenericLoader<BlockPropertiesPredicate>(){

        @Override
        public BlockPropertiesPredicate deserialize(JsonObject json) {
            class_2248 block = (class_2248)JsonHelper.getAsEntry(class_7923.field_41175, json, "block");
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map.Entry entry : class_3518.method_15296((JsonObject)json, (String)"properties").entrySet()) {
                class_2769<?> property = BlockPropertiesPredicate.parseProperty(block, (String)entry.getKey(), JSON_EXCEPTION);
                builder.add((Object)Matcher.deserialize(property, (JsonElement)entry.getValue()));
            }
            return new BlockPropertiesPredicate(block, (List<Matcher>)builder.build());
        }

        @Override
        public void serialize(BlockPropertiesPredicate object, JsonObject json) {
            json.addProperty("block", Objects.requireNonNull(class_7923.field_41175.method_10221((Object)object.block)).toString());
            JsonObject properties = new JsonObject();
            for (Matcher matcher : object.properties) {
                properties.add(matcher.property().method_11899(), matcher.serialize());
            }
            json.add("properties", (JsonElement)properties);
        }

        @Override
        public BlockPropertiesPredicate fromNetwork(class_2540 buffer) {
            class_2248 block = (class_2248)class_7923.field_41175.method_10200(buffer.method_10816());
            int size = buffer.method_10816();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)Matcher.fromNetwork(block, buffer));
            }
            return new BlockPropertiesPredicate(block, (List<Matcher>)builder.build());
        }

        @Override
        public void toNetwork(BlockPropertiesPredicate object, class_2540 buffer) {
            buffer.method_10804(class_7923.field_41175.method_10206((Object)object.block));
            buffer.method_10804(object.properties.size());
            for (Matcher matcher : object.properties) {
                matcher.toNetwork(buffer);
            }
        }
    };

    @Override
    public boolean matches(class_2680 input) {
        if (input.method_26204() != this.block) {
            return false;
        }
        for (Matcher matcher : this.properties) {
            if (matcher.matches(input)) continue;
            return false;
        }
        return true;
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<class_2680>> getLoader() {
        return LOADER;
    }

    private static class_2769<?> parseProperty(class_2248 block, String name, Function<String, RuntimeException> exception) {
        class_2769 property = block.method_9595().method_11663(name);
        if (property == null) {
            throw exception.apply("Property " + name + " does not exist in block " + class_7923.field_41175.method_10221((Object)block));
        }
        return property;
    }

    public static Builder block(class_2248 block) {
        return new Builder(block);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Matcher {
        public boolean matches(class_2680 var1);

        public class_2769<?> property();

        public JsonElement serialize();

        public void toNetwork(class_2540 var1);

        private static <T extends Comparable<T>> T parseValue(class_2769<T> property, String name, Function<String, RuntimeException> exception) {
            Optional value = property.method_11900(name);
            if (value.isPresent()) {
                return (T)((Comparable)value.get());
            }
            throw exception.apply("Unknown property value " + name);
        }

        public static <T extends Comparable<T>> Matcher deserialize(class_2769<T> property, JsonElement element) {
            if (element.isJsonPrimitive()) {
                return new SetMatcher<T>(property, Matcher.parseValue(property, class_3518.method_15287((JsonElement)element, (String)property.method_11899()), JSON_EXCEPTION));
            }
            if (element.isJsonArray()) {
                return new SetMatcher<ImmutableSet>(property, ImmutableSet.copyOf(JsonHelper.parseList(element.getAsJsonArray(), property.method_11899(), (e, key) -> Matcher.parseValue(property, class_3518.method_15287((JsonElement)e, (String)key), JSON_EXCEPTION))));
            }
            if (element.isJsonObject()) {
                JsonObject json = element.getAsJsonObject();
                Object min = null;
                Object max = null;
                if (json.has("min")) {
                    min = Matcher.parseValue(property, class_3518.method_15265((JsonObject)json, (String)"min"), JSON_EXCEPTION);
                }
                if (json.has("max")) {
                    max = Matcher.parseValue(property, class_3518.method_15265((JsonObject)json, (String)"max"), JSON_EXCEPTION);
                }
                if (min == null) {
                    if (max == null) {
                        throw new JsonSyntaxException("Either min or max must be set for a range matcher");
                    }
                } else if (min.equals(max)) {
                    return new SetMatcher<Object>(property, min);
                }
                return new RangeMatcher<Object>((class_2769<Object>)property, min, max);
            }
            throw new JsonSyntaxException("Invalid matcher type " + class_3518.method_15266((JsonElement)element));
        }

        public static Matcher fromNetwork(class_2248 block, class_2540 buffer) {
            class_2769<?> property = BlockPropertiesPredicate.parseProperty(block, buffer.method_10800(Short.MAX_VALUE), DECODER_EXCEPTION);
            return Matcher.fromNetwork(property, buffer);
        }

        public static <T extends Comparable<T>> Matcher fromNetwork(class_2769<T> property, class_2540 buffer) {
            int size = buffer.method_10816();
            if (size == 0) {
                Object min = null;
                Object max = null;
                RangeType rangeType = (RangeType)buffer.method_10818(RangeType.class);
                if (rangeType != RangeType.MAX) {
                    min = Matcher.parseValue(property, buffer.method_10800(Short.MAX_VALUE), DECODER_EXCEPTION);
                }
                if (rangeType != RangeType.MIN) {
                    max = Matcher.parseValue(property, buffer.method_10800(Short.MAX_VALUE), DECODER_EXCEPTION);
                }
                return new RangeMatcher<Object>((class_2769<Object>)property, min, max);
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < size; ++i) {
                builder.add(Matcher.parseValue(property, buffer.method_10800(Short.MAX_VALUE), DECODER_EXCEPTION));
            }
            return new SetMatcher<ImmutableSet>(property, builder.build());
        }
    }

    public static class Builder {
        private final class_2248 block;
        private final Map<class_2769<?>, Matcher> matchers = new LinkedHashMap();

        private Builder matches(Matcher matcher) {
            class_2769<?> property = matcher.property();
            if (!this.block.method_9595().method_11659().contains(property)) {
                throw new IllegalArgumentException("Property " + property + " does not exist in block " + this.block);
            }
            Matcher original = this.matchers.put(property, matcher);
            if (original != null) {
                throw new IllegalArgumentException("Matcher for property already exists: previous matcher " + original);
            }
            return this;
        }

        public <T extends Comparable<T>> Builder matches(class_2769<T> property, Set<T> values) {
            return this.matches(new SetMatcher<Set<T>>(property, values));
        }

        @SafeVarargs
        public final <T extends Comparable<T>> Builder matches(class_2769<T> property, T ... values) {
            return this.matches(property, Set.of(values));
        }

        public <T extends Comparable<T>> Builder range(class_2769<T> property, T min, T max) {
            if (Objects.equals(min, max)) {
                return this.matches(property, new Comparable[]{min});
            }
            return this.matches(new RangeMatcher<T>(property, min, max));
        }

        public <T extends Comparable<T>> Builder min(class_2769<T> property, T min) {
            return this.matches(new RangeMatcher<Object>((class_2769<Object>)property, min, null));
        }

        public <T extends Comparable<T>> Builder max(class_2769<T> property, T max) {
            return this.matches(new RangeMatcher<Object>((class_2769<Object>)property, null, max));
        }

        public BlockPropertiesPredicate build() {
            if (this.matchers.isEmpty()) {
                throw new IllegalArgumentException("Must have at least one property");
            }
            return new BlockPropertiesPredicate(this.block, (List<Matcher>)ImmutableList.copyOf(this.matchers.values()));
        }

        private Builder(class_2248 block) {
            this.block = block;
        }
    }

    public record RangeMatcher<T extends Comparable<T>>(class_2769<T> property, @Nullable T min, @Nullable T max) implements Matcher
    {
        public RangeMatcher {
            RangeType.fromValues(min, max);
        }

        @Override
        public boolean matches(class_2680 state) {
            Comparable value = state.method_11654(this.property);
            return !(this.min != null && value.compareTo(this.min) < 0 || this.max != null && value.compareTo(this.max) > 0);
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            if (this.min != null) {
                json.addProperty("min", this.property.method_11901(this.min));
            }
            if (this.max != null) {
                json.addProperty("max", this.property.method_11901(this.max));
            }
            return json;
        }

        @Override
        public void toNetwork(class_2540 buffer) {
            buffer.method_10814(this.property.method_11899());
            buffer.method_10804(0);
            buffer.method_10817((Enum)RangeType.fromValues(this.min, this.max));
            if (this.min != null) {
                buffer.method_10814(this.property.method_11901(this.min));
            }
            if (this.max != null) {
                buffer.method_10814(this.property.method_11901(this.max));
            }
        }
    }

    private static enum RangeType {
        FULL,
        MIN,
        MAX;


        public static RangeType fromValues(@Nullable Object min, @Nullable Object max) {
            if (max == null) {
                if (min == null) {
                    throw new IllegalArgumentException("Cannot have both min and max null");
                }
                return MIN;
            }
            if (min == null) {
                return MAX;
            }
            return FULL;
        }
    }

    public record SetMatcher<T extends Comparable<T>>(class_2769<T> property, Set<T> values) implements Matcher
    {
        public SetMatcher {
            if (values.isEmpty()) {
                throw new IllegalArgumentException("Values must not be empty");
            }
        }

        public SetMatcher(class_2769<T> property, T value) {
            this((class_2769<Set<T>>)property, Set.of(value));
        }

        @Override
        public boolean matches(class_2680 state) {
            return this.values.contains(state.method_11654(this.property));
        }

        @Override
        public JsonElement serialize() {
            if (this.values.size() == 1) {
                return new JsonPrimitive(this.property.method_11901((Comparable)this.values.iterator().next()));
            }
            JsonArray array = new JsonArray();
            for (Comparable value : this.values) {
                array.add(this.property.method_11901(value));
            }
            return array;
        }

        @Override
        public void toNetwork(class_2540 buffer) {
            buffer.method_10814(this.property.method_11899());
            buffer.method_10804(this.values.size());
            for (Comparable value : this.values) {
                buffer.method_10814(this.property.method_11901(value));
            }
        }
    }
}

